<?php
require "header.php";
?>
<style>
    th{
        color:#000 !important;
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card bg-white">
            <div class="card-header h3 text-dark">
                Moves
                <button class="float-end btn btn-primary" data-bs-toggle="modal" data-bs-target="#create-modal">
                   + Create Move Number
                </button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table" id="table">
                        <thead>
                            <tr>
                                <th>Move Number</th>
                                <th>Amount</th>
                                <th>Edit</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $get_moves=mysqli_query($conn, "SELECT * FROM moves ORDER BY id DESC");
                            if(mysqli_num_rows($get_moves)>0){
                                while($task=mysqli_fetch_assoc($get_moves)){
                                    $id = $task['id'];
                                    $move_num=$task['move_num'];
                                    $amount=$task['amount'];
                            ?>
                                    <tr>
                                        <td><?php echo $move_num; ?></td>
                                        <td><?php echo $amount; ?></td>
                                        <td><button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#package-<?php echo $id; ?>"><i class="bx bx-pencil"></i></button></td>
                                        <td><button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#deletepackage-<?php echo $id; ?>"><i class="bx bx-trash"></i></button></td>
                                    </tr>
                            <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$get_moves=mysqli_query($conn, "SELECT * FROM moves ORDER BY id");
if(mysqli_num_rows($get_moves)>0){
    while($task=mysqli_fetch_assoc($get_moves)){
        $id = $task['id'];
        $move_num = $task['move_num'];
        $amount = $task['amount'];
?>

        <div class="modal fade" id="package-<?php echo $id; ?>">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header h3 text-dark">
                        Edit Move Item
                        <button class="btn btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post">
                            <input type="hidden" name="id" value="<?php echo $id; ?>"/>
                            <div class="form-group my-2">
                                <label class="form-label">Move Number</label>
                                <input type="text" name="move_num" class="form-control" value="<?php echo $move_num; ?>"/>
                            </div>
                            <div class="form-group my-2">
                                <label class="form-label">Amount</label>
                                <input type="text" name="amount" class="form-control" value="<?php echo $amount; ?>"/>
                            </div>
                            <div class="form-group m-3">
                                <button name="edit" class="btn btn-primary">Edit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="deletepackage-<?php echo $id; ?>">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header h3 text-dark">
                        Delete Move Number <?php echo $move_num; ?>
                        <button class="btn btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post">
                            <input type="hidden" name="move_num" value="<?php echo $move_num; ?>"/>
                            <div class="form-group m-3">
                                <button name="delete" class="btn btn-primary">Delete</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

<?php
    }
}
?>

<div class="modal fade" id="create-modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header h3 text-dark">
                Create Move Number
                <button class="btn btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group my-2">
                        <label class="form-label">Move Number</label>
                        <input type="text" name="name" class="form-control" required/>
                    </div>
                    <div class="form-group my-2">
                        <label class="form-label">Amount (USD)</label>
                        <input type="number" name="amount" class="form-control" required/>
                    </div>
                    <div class="form-group m-3">
                        <button name="create" class="btn btn-primary">Create</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
require "footer.php";

// delete package
if(isset($_POST['delete'])){
    $move_num=mysqli_real_escape_string($conn, $_POST['move_num']);
    $delete=mysqli_query($conn, "DELETE FROM moves WHERE move_num='$move_num'");
    if($delete){
        echo "<script>
            swal('Great', 'Move Number Deleted', 'success')
            .then(() => {
                location.replace('moves');
            });
        </script>";
    }
}

// edit package
if(isset($_POST['edit'])){
    $id = $_POST['id'];
    $move_num=mysqli_real_escape_string($conn, $_POST['move_num']);
    $amount=mysqli_real_escape_string($conn, $_POST['amount']);
    $update=mysqli_query($conn, "UPDATE moves SET move_num='$move_num', amount='$amount' WHERE id='$id'");
    if($update){
        echo "<script>
            swal('Great', 'Move Info Edited', 'success')
            .then(() => {
                location.replace('moves');
            });
        </script>";
    }
}

// create new package
if(isset($_POST['create'])){
    $move_num=mysqli_real_escape_string($conn, $_POST['name']);
    $amount=mysqli_real_escape_string($conn, $_POST['amount']);
    $check = mysqli_query($conn, "SELECT * FROM moves WHERE move_num = '$move_num'");
    if(mysqli_num_rows($check) > 0){
        echo "<script>
            swal('Oops', 'Number Already Exists', 'error');
        </script>";
    } else {
        $insert=mysqli_query($conn, "INSERT INTO moves (move_num, amount) VALUES ('$move_num', '$amount')");
        if($insert){
            echo "<script>
                swal('Great', 'Move Item Created', 'success')
                .then(() => {
                    location.replace('moves');
                });
            </script>";
        } else {
            echo "<script>
                swal('Oops', 'An Error Occurred', 'error');
            </script>";
        }
    }
}
?>
