<?php
require "header.php";
?>




<div class="formbold-main-wrapper">
  <!-- Author: FormBold Team -->
  <!-- Learn More: https://formbold.com -->
  <div class="formbold-form-wrapper">

    <!-- Step 1: Personal and Employment Information -->
    <form id="application-form"  method="POST" enctype="multipart/form-data" action="javascript:void(0)">
      <div id="form-step-1">
      <h2 class="formbold-form-title">Agsmoves Job Application Form</h2>
      
      <!-- Personal Information -->
      <div class="formbold-section">
        <h3 class="formbold-section-title">Personal Information</h3>
        <div class="formbold-input-flex">
          <div class="formbold-input-group">
            <label for="fullname" class="formbold-form-label"> Full Name </label>
            <input
              type="text"
              name="fullname"
              id="fullname"
              placeholder="Your full name"
              class="formbold-form-input"
              required
            />
          </div>
          <div class="formbold-input-group">
            <label for="email" class="formbold-form-label"> Email Address </label>
            <input
              type="email"
              name="email"
              id="email"
              placeholder="example@email.com"
              class="formbold-form-input"
              required
            />
          </div>
        </div>

        <div class="formbold-input-flex">
          <div class="formbold-input-group">
            <label for="phone" class="formbold-form-label"> Phone Number </label>
            <input
              type="tel"
              name="phone"
              id="phone"
              placeholder="Enter Phone Number"
              class="formbold-form-input"
              required
            />
          </div>
          <div class="formbold-input-group">
            <label for="address" class="formbold-form-label"> Address </label>
            <input
              type="text"
              name="address"
              id="address"
              placeholder="Your address"
              class="formbold-form-input"
              required
            />
          </div>
        </div>

        <div class="formbold-input-flex">
          <div class="formbold-input-group">
            <label for="city" class="formbold-form-label"> City </label>
            <input
              type="text"
              name="city"
              id="city"
              placeholder="Your city"
              class="formbold-form-input"
              required
            />
          </div>
          <div class="formbold-input-group">
            <label for="state" class="formbold-form-label"> State </label>
            <input
              type="text"
              name="state"
              id="state"
              placeholder="Your state"
              class="formbold-form-input"
              required
            />
          </div>
        </div>

        <div class="formbold-input-group">
          <label for="zip" class="formbold-form-label"> Zip Code </label>
          <input
            type="text"
            name="zip"
            id="zip"
            placeholder="Your zip code"
            class="formbold-form-input"
            required
          />
        </div>
      </div>

      <!-- Employment Information -->
      <div class="formbold-section">
        <h3 class="formbold-section-title">Employment Information</h3>
        <div class="formbold-input-group">
          <label for="eligible" class="formbold-form-label"> Are you legally eligible to work in the United States? </label>
          <select
            name="eligible"
            id="eligible"
            class="formbold-form-input"
            required
          >
            <option value="yes">Yes</option>
            <option value="no">No</option>
          </select>
        </div>
        <div class="formbold-input-group">
          <label for="conviction" class="formbold-form-label"> Have you ever been convicted of a felony? </label>
          <select
            name="conviction"
            id="conviction"
            class="formbold-form-input"
            required
          >
            <option value="yes">Yes</option>
            <option value="no">No</option>
          </select>
        </div>
        
        <div class="formbold-input-group">
          <label for="explanation" class="formbold-form-label"> If yes, please explain: </label>
          <textarea
            name="explanation"
            id="explanation"
            placeholder="Explanation"
            class="formbold-form-input"
            required
            rows="4"
          ></textarea>
        </div>
      </div>

      <!-- Employment History -->
      <div class="formbold-section">
        <h3 class="formbold-section-title">Employment History</h3>

        <div class="formbold-employment-history">
          <div class="formbold-employer">
            <h4 class="formbold-employer-title">1. Employer Name:</h4>
            <div class="formbold-input-group">
              <label for="employer1-name" class="formbold-form-label"> Employer Name </label>
              <input
                type="text"
                name="employer1-name"
                id="employer1-name"
                class="formbold-form-input"
                required
              />
            </div>

            <div class="formbold-input-group">
              <label for="employer1-position" class="formbold-form-label"> Position </label>
              <input
                type="text"
                name="employer1-position"
                id="employer1-position"
                class="formbold-form-input"
                required
              />
            </div>

            <div class="formbold-input-group">
              <label for="employer1-dates" class="formbold-form-label"> Dates of Employment </label>
              <input
                type="text"
                name="employer1-dates"
                id="employer1-dates"
                class="formbold-form-input"
                required
              />
            </div>

            <div class="formbold-input-group">
              <label for="employer1-responsibilities" class="formbold-form-label"> Responsibilities </label>
              <textarea
                name="employer1-responsibilities"
                id="employer1-responsibilities"
                class="formbold-form-input"
                required
                rows="4"
              ></textarea>
            </div>

            <div class="formbold-input-group">
              <label for="employer1-reason" class="formbold-form-label"> Reason for Leaving </label>
              <textarea
                name="employer1-reason"
                id="employer1-reason"
                class="formbold-form-input"
                required
                rows="4"
              ></textarea>
            </div>
          </div>

       
        </div>
      </div>

      <button type="button" class="formbold-btn" onclick="showStep2()">Next</button>
      </div> 
    

    <!-- Step 2: Identification Information and Document Uploads -->
    
      <div id="form-step-2" style="display:none">
      <div class="formbold-section">
        <h3 class="formbold-section-title">Identification Information</h3>
        <div class="formbold-input-flex">
          <div class="formbold-input-group">
            <label for="drivers-license" class="formbold-form-label"> Driver’s License Number </label>
            <input
              type="text"
              name="drivers-license"
              id="drivers-license"
              class="formbold-form-input"
              required
            />
          </div>
          <div class="formbold-input-group">
            <label for="ssn" class="formbold-form-label"> Social Security Number (SSN) </label>
            <input
              type="text"
              name="ssn"
              id="ssn"
              class="formbold-form-input"
              required
               maxlength="9"
            />
          </div>
        </div>
      </div>

      <!-- Document Uploads -->
      <div class="formbold-section">
        <h3 class="formbold-section-title">Document Uploads</h3>

        <div class="formbold-dl-upload">
          <div class="formbold-dl-upload-flex">
            <label for="upload-front" class="formbold-form-label">
              <i class="icon-upload"></i> Driver’s License Front Copy
            </label>
            <input
              type="file"
              name="upload-front"
              id="upload-front"
              class="formbold-form-file"
              required
            />
          </div>
          <div class="formbold-dl-upload-flex">
            <label for="upload-back" class="formbold-form-label">
              <i class="icon-upload"></i> Driver’s License Back Copy
            </label>
            <input
              type="file"
              name="upload-back"
              id="upload-back"
              class="formbold-form-file"
              required
            />
          </div>
          <div class="formbold-dl-upload-flex">
            <label for="upload-ssn" class="formbold-form-label">
              <i class="icon-upload"></i> SSN Copy
            </label>
            <input
              type="file"
              name="upload-ssn"
              id="upload-ssn"
              class="formbold-form-file"
              required
            />
          </div>
        </div>
      </div>

      <!-- Submit Button -->
      <button type="button" class="formbold-btn" onclick="showStep1()">Back</button>
      <button type="submit" class="formbold-btn">Apply Now</button>
      </div>
    </form>
  </div>
</div>

<script>
    function showStep2() {
      // Get all input elements in the first step
      const step1Inputs = document.querySelectorAll('#form-step-1 input, #form-step-1 select, #form-step-1 textarea');
      
      // Check if all required fields in the first step are valid
      let valid = true;
      step1Inputs.forEach(input => {
        if (!input.checkValidity()) {
          valid = false;
          input.reportValidity();
        }
      });
      
      if (valid) {
        document.getElementById('form-step-1').style.display = 'none';
        document.getElementById('form-step-2').style.display = 'block';
      }
    }
    
    function showStep1() {
      document.getElementById('form-step-2').style.display = 'none';
      document.getElementById('form-step-1').style.display = 'block';
    }

  document.querySelectorAll('.formbold-form-file').forEach(inputElement => {
    const labelElement = document.querySelector(`label[for=${inputElement.id}]`);

    inputElement.addEventListener('change', event => {
      const fileName = event.target.files[0] ? event.target.files[0].name : 'No file chosen';
      labelElement.textContent = fileName;
    });
  });
</script>



<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}
body {
  font-family: 'Inter', sans-serif;
}
.formbold-main-wrapper {
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 24px;
}
.formbold-form-wrapper {
  margin: 0 auto;
  max-width: 600px;
  width: 100%;
  background: white;
  padding: 20px;
  border-radius: 8px;
  box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
}
.formbold-form-title {
  font-size: 24px;
  margin-bottom: 20px;
  text-align: center;
  color: #07074D;
}
.formbold-section {
  margin-bottom: 20px;
}
.formbold-section-title {
  font-size: 18px;
  margin-bottom: 10px;
  color: #07074D;
}
.formbold-input-flex {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
}
.formbold-input-group {
  flex: 1;
  min-width: 200px;
}
.formbold-form-input {
  width: 100%;
  padding: 12px 20px;
  border-radius: 5px;
  border: 1px solid #dde3ec;
  background: #ffffff;
  font-weight: 500;
  font-size: 16px;
  color: #536387;
  outline: none;
}
.formbold-form-input::placeholder {
  color: rgba(83, 99, 135, 0.5);
}
.formbold-form-input:focus {
  border-color: #B00000;
  box-shadow: 0px 3px 8px rgba(0, 0, 0, 0.1);
}
.formbold-form-label {
  color: #07074D;
  font-weight: 500;
  font-size: 14px;
  margin-bottom: 8px;
}
.formbold-form-file {
  display: none;
}
.formbold-btn {
  text-align: center;
  width: 100%;
  font-size: 16px;
  border-radius: 5px;
  padding: 12px 20px;
  border: none;
  font-weight: 500;
  background-color: #B00000;
  color: white;
  cursor: pointer;
  margin-top: 20px;
}
.formbold-btn:hover {
  box-shadow: 0px 3px 8px rgba(0, 0, 0, 0.1);
}
.formbold-dl-upload {
  border: 1px dashed #dde3ec;
  border-radius: 5px;
  padding: 15px;
  background: #f9fafb;
  margin-bottom: 15px;
}
.formbold-dl-upload-flex {
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 10px;
}
.formbold-dl-upload label {
  font-size: 16px;
  font-weight: 600;
  color: #536387;
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 10px;
}
.formbold-dl-upload label::before {
  content: 'Upload';
  display: inline-block;
  background: #B00000;
  color: white;
  padding: 5px 15px;
  border-radius: 5px;
  cursor: pointer;
}
.formbold-dl-upload label::after {
  content: ' No file chosen';
  color: #536387;
  margin-left: 10px;
}
.icon-upload {
  font-size: 24px;
  color: #B00000;
}

@media (max-width: 768px) {
  .formbold-input-flex {
    flex-direction: column;
  }
}
</style>
