<?php
require "header.php";
?>

<div class="thank-you-container">
  <div class="thank-you-content">
    <h1 class="thank-you-title">Thank You for Your Application!</h1>
    <p class="thank-you-message">
      We appreciate your interest in joining Agsmoves. Our team will review your application and contact you if we find your qualifications match our needs.
    </p>
    <p class="thank-you-message">
      In the meantime, if you have any questions, feel free to reach out to us at <a href="mailto:support@agsmoves.com">support@agsmoves.com</a>.
    </p>
    <a href="index.php" class="thank-you-btn">Return to Home</a>
  </div>
</div>

<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

body {
  font-family: 'Inter', sans-serif;
  background: #f4f4f9;
  display: flex;
  align-items: center;
  justify-content: center;
  height: 100vh;
  margin: 0;
}

.thank-you-container {
  display: flex;
  align-items: center;
  justify-content: center;
  height: 100vh;
  width: 100%;
}

.thank-you-content {
  max-width: 600px;
  width: 100%;
  padding: 40px;
  background: white;
  border-radius: 8px;
  box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
  text-align: center;
}

.thank-you-title {
  font-size: 28px;
  color: #07074D;
  margin-bottom: 20px;
}

.thank-you-message {
  font-size: 16px;
  color: #536387;
  margin-bottom: 20px;
}

.thank-you-message a {
  color: #B00000;
  text-decoration: none;
}

.thank-you-message a:hover {
  text-decoration: underline;
}

.thank-you-btn {
  display: inline-block;
  padding: 12px 20px;
  font-size: 16px;
  color: white;
  background-color: #B00000;
  border: none;
  border-radius: 5px;
  text-decoration: none;
  cursor: pointer;
  margin-top: 20px;
}

.thank-you-btn:hover {
  background-color: #9A0000;
}
</style>
